//This shader is mainly used for Draw Image.
#define NONORMAL
#define LIGHTING
#include "InventorBasicEffectDx10.fxh"


struct VSPosTex
{
	float3 Pos		: Position;
	float4 offTex		: Color;//xy: position offset; zw:texture coordinate
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosTex( VSPosTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	float4 outpos = mul(LocalPos,g_matWorldViewProj);
	
	//Perspective divide
	outpos.xyz /= outpos.w;
	outpos.w = 1.0f;
	
	//When drawing image, it starts with a marker point in model space.
	//The other 3 points would be decided in npc space. There are 3 offsets needed in npc space. WG
	outpos.xy += Input.offTex.xy*2.0f/g_ViewPort;

	Out.Pos = outpos;

	//float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	if(g_enabledLight)
	{
		float Opacity = g_Misc.y;
		TripleColor Color = CalcLightingAmb(Input.Pos,g_Emissive, g_Ambient,Opacity);
		Out.ColorD = Color.Diffuse;
	}else
	{
		Out.ColorD = g_Emissive;
	}
	Out.ColorD.w = g_Misc.y;

#ifdef DIFFUSE_TEXTURE	
	Out.Tex = float4(Input.offTex.zw, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif
	if(g_fogEnabled)
	{
		float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
 	//Apply user specified clipping
	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
	if( g_bClippingEnable )
	{
		CalcClipping(LocalPos, Out);
	}
	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosTex( VSOutput Input ) : SV_Target
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	
	if(Input.ColorD.a < g_Misc.w)
		discard;
	float4 Color = saturate(Input.ColorD);
if(g_fogEnabled)
	return Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
else
	return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosTex
{
    pass P0
    {   
	SetVertexShader(CompileShader(vs_4_0,VS_PosTex()));
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosTex()) );
    }
}